'use strict';

/**
 * Configure these to control smoothing and the frequency.
 */
let frequencyResolution = 16; // Must be 16, 32 or 64 per channel.
let sourceFrequency = 0; // Must be smaller than frequencyResolution. Lower values for bass, higher for treble.
let smoothingRate = 2;
let minimumValue = 0.0;
let maximumValue = 1.0;

/**
 * This creates a permanent link to the audio response data.
 */
let audioBuffer = engine.registerAudioBuffers(frequencyResolution);
var smoothValue = 0;
var initialValue;
const valueDelta = maximumValue - minimumValue;

/**
 */
export function update() {
	let audioDelta = audioBuffer.average[sourceFrequency] - smoothValue;
	
	smoothValue += audioDelta * engine.frametime * smoothingRate;
	smoothValue = Math.min(1.0, smoothValue);

	return initialValue * (smoothValue * valueDelta + minimumValue);
}

/**
 */
export function init(value) {
	initialValue = value;
}

